<?php defined('PF_VERSION') OR exit('Access denied'); ?>
<?php

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
class Pf_Faq_Controller extends Pf_Plugin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->view->set_path('faq');
        $this->data['validated'] = array();
        $this->model = new Pf_Faq_Model();
        $this->acl = array(1, 2, 3);
        $this->check_acl();
    }

    public function main()
    {
        $faqs = get_option('faq');
        $url = admin_url('admin-page=faq', false);
        if ($this->input->has_get('kw')) {
            $kw = $this->input->get('kw');
            $faqs = search_by_key($faqs, $kw, 'title');
            $url .= "&kw={$kw}";
        }
        if ($this->input->has_get('status')) {
            $status = (int) $this->input->get('status') === 1 ? 1 : 0;
            $faqs = search_by_key($faqs, $status, 'status');
            $url .= "&status={$status}";
        }
        $page = ($this->input->has_get('current')) ? (int) $this->input->get('current') : 1;
        $pagination = new Pf_Paginator(count($faqs), NUM_PER_PAGE, 'current');
        $this->data['faqs'] = pagination($faqs, $page);
        $this->data['pagination'] = $pagination;
        $this->data['url'] = $url;
        $this->view->render('main', $this->data);
    }

    //Bulk Action
    private function delete_multiple($data, $ids)
    {
        foreach ($ids as $value) {
            unset($data[$value]);
        }
        update_option('faq', $data);
    }

    private function update_status($data, $ids, $status)
    {
        foreach ($ids as $value) {
            $data[$value]['status'] = $status;
        }
        update_option('faq', $data);
    }

    public function bulk_action()
    {
        if ($this->input->has_post('id')) {
            $current = $this->input->has_post('current') ? $this->input->post('current') : 0;
            $action = $this->input->post('action');
            $data = get_option('faq');
            $id = $this->input->post('id');
            $ids = array_values($id);
            if ($action == 3) {
                $this->delete_multiple($data, $ids);
            } else {
                $this->update_status($data, $ids, $action);
            }
            $this->session->flash('success', __('Your action is successful', 'faq'));
        }
        Pf_Plugin_Redirect::to("&act&current={$current}");
    }

    private function save()
    {
        if ($this->input->has_post('title')) {
            $data = get_option('faq');
            if (!is_array($data)) {
                $data = array();
            }
            $input_all = $this->input->post();
            $this->validator->validation_rules($this->model->rules);
            if ($this->validator->run($input_all) !== false) {
                $faq = array(
                    'title' => $input_all['title'],
                    'status' => $input_all['status'],
                    'description' => $input_all['description'],
                    'list' => data_question_answer($input_all['question'], $input_all['answer'])
                );
                $id = $this->input->has_post('id') ? $this->input->post('id') : uniqid();
                $data["{$id}"] = $faq;
                update_option('faq', $data);
                $this->session->flash('success', __('Your action is successful', 'faq'));
                Pf_Plugin_Redirect::to('&act=edit&id=&id=' . $id);
            } else {
                $this->data['validated'] = $this->validator->get_readable_errors(false);
            }
        }
    }

    //Find by id
    public function find($id)
    {
        $data = get_option('faq');
        if (is_array($data)) {
            foreach ($data as $key => $value) {
                if ($key == $id) {
                    return $value;
                }
            }
        }
        return false;
    }

    public function get_list_faq_post()
    {
        if ($this->input->has_post('question')) {
            return array(
                'question' => $this->input->has_post('question') ? $this->input->post('question') : '',
                'answer' => $this->input->has_post('answer') ? $this->input->post('answer') : ''
            );
        }
    }

    public function create()
    {
        $this->save();
        $this->data['list_qa'] = $this->get_list_faq_post();
        //dd($this->data['list_qa']);
        $this->data['number_qa'] = $this->input->has_post('number_qa') ? $this->input->post('number_qa') : 1;
        $this->data['status'] = $this->model->get_status_faq();
        $this->view->render('create', $this->data);
    }

    public function edit()
    {
        if ($this->input->has_get('id')) {
            $id = $this->input->get('id');
            $data = $this->find($id);
            is_array($data) || Pf_Plugin_Redirect::to('&act=main');
            if ($this->input->has_post('question')) {
                $data['list'] = $this->get_list_faq_post();
                $this->data['number_qa'] = $this->input->has_post('number_qa') ? $this->input->post('number_qa') : 1;
            } else {
                $this->data['number_qa'] = count($data['list']);
                $data['list'] = clean_data($data['list']);
            }
            $this->save();
            $this->data['status'] = $this->model->get_status_faq();
            $this->data['faq'] = $data;
            $this->data['id'] = $id;
            $this->view->render('edit', $this->data);
        } else {
            Pf_Plugin_Redirect::to('&act=main');
        }
    }

    public function delete()
    {
        if ($this->input->has_get('id')) {
            $id = $this->input->get('id');
            is_array($this->find($id)) || Pf_Plugin_Redirect::to('&act&id');
            $data = get_option('faq');
            unset($data[$id]);
            update_option('faq', $data);
            $this->session->flash('success', __('Your action is successful', 'faq'));
        }
        Pf_Plugin_Redirect::to('&act&id');
    }

    /*
     * Status
     */

    public function status()
    {
        $curent = $this->input->get('current');
        if ($this->input->has_get('id') && $this->input->has_get('type')) {
            $id = $this->input->get('id');
            $status = $this->input->get('type') == 2 ? 0 : 1;
            $this->update_status(get_option('faq'), array($id), $status);
            $this->session->flash('success', __('Status is updated successfully', 'faq'));
        }
        Pf_Plugin_Redirect::to('&act&id&type&current=' . $curent);
    }

}
